#!/bin/bash
exp_id=$1
num_shadow=$2

DATA_PATH="datasets"
SAVE_PATH="exps/DSA_real_init/syn_img"
LIRA_PATH="exps/DSA_real_init/lira"

python src/dd/main_DC.py \
    --method DSA \
    --dataset CIFAR10 \
    --model ConvNet \
    --ipc 1000 \
    --dsa_strategy color_crop_cutout_flip_scale_rotate \
    --init real \
    --lr_img 0.1 \
    --num_eval 1 \
    --eval_freq 50 \
    --Iteration 300 \
    --exp_id $exp_id \
    --num_shadow $num_shadow \
    --num_canaries 500 \
    --data_path $DATA_PATH \
    --lira_path $LIRA_PATH \
    --save_path $SAVE_PATH > logs/dsa/DSA_real_init_exp_id_$exp_id.log
